; //--------------------- Constants -------------------------------

; genral definitions
#define ZERO c-91.x
#define ONE c-91.y
#define PI c-91.z
#define EPSILON c-91.w
#define R_MODEL_VERT r0
#define R_MODEL_NORMAL r1

; fog definitions
#define R_VERT_TO_FOG r5
#define R_VERT_TO_INTERSECT r6
#define R_VERT_DISTANCE r7
#define R_INTERSECT_DISTANCE r8
#define IS_ZERO	r9
#define IS_NEG r10
#define R_FOG r11

; lighting definitions
#define R_TEMP r6
#define R_VERT_TO_LIGHT r7
#define R_ATTENUATION r8
#define R_INTENSITY r9
#define R_DIFFUSE r10
#define R_SPECULAR r11

; //--------------------- Version -------------------------------

; vertex shader version 1.1
xvs.1.1

; //--------------- Apply Vertex Weights ------------------------

; first bone
mov	a0.x, v4.x
mul	r2, v5.x, c[ a0.x + 0 ]
mul	r3, v5.x, c[ a0.x + 1 ]
mul	r4, v5.x, c[ a0.x + 2 ]

; second bone
mov	a0.x, v4.y
mad	r2, v5.y, c[ a0.x + 0 ], r2
mad	r3, v5.y, c[ a0.x + 1 ], r3
mad	r4, v5.y, c[ a0.x + 2 ], r4

; third bone
mov	a0.x, v4.z
mad	r2, v5.z, c[ a0.x + 0 ], r2
mad	r3, v5.z, c[ a0.x + 1 ], r3
mad	r4, v5.z, c[ a0.x + 2 ], r4

; transform weighted position
dp4	R_MODEL_VERT.x, v0, r2
dp4	R_MODEL_VERT.y, v0, r3
dp4	R_MODEL_VERT.z, v0, r4
mov R_MODEL_VERT.w, ONE

; rotate weighted normal
dp3	R_MODEL_NORMAL.x, v1, r2
dp3	R_MODEL_NORMAL.y, v1, r3
dp3	R_MODEL_NORMAL.z, v1, r4

; //------------------- Xform Vertices -----------------------------

;transform vertices by view/projection matrix
m4x4 oPos, R_MODEL_VERT, c-96

; //----------------- Calculate Texture UV -------------------------

;copy texture coordinates to output   
mov oT0.xy, v3

; //------------------------ Set Fog -------------------------------

; copy zero to fog value
mov oFog.x, ZERO

; //----------------------- Set Color ------------------------------

mov oD0, ONE